﻿var onlyNumberRegex = /[^0-9]*/g;
var panelistFilter = {
    panelId: 0,
    displayInEditor: false,
    context: null,
    isPopupView: false,
    filterLoaded: false,
    isExpandedPanelistFilter: false,
    expandedFilterActionOnPopupClose: 'none',
    expandedFilterSavedConfiguration: null,
    tooltipStyle: "width:auto; min-width:100px; padding:5px; border-radius: 2px;",
    tooltipPosition: { "my": "right", "at": "left" },
    initializeAutoCompletes: function () {
        panelistFilter.initializeDateFormat();
        panelistFilter.initializeFieldCustomProperties();

        $(".filtersAutoComplete", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPanelistFilters", "Panelists", "Panel"),
            select: function (event, data) {
                if (data.item) {
                    panelistFilter.loadFilter(data.item.Value);
                }
            },
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition
        });

        $(".v-panelistImports", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPanelistImports", "Panelists", "Panel"),
            multipleSelection: true,
            hideSelectedItems: true,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition
        });

        $(".v-groups", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetGroups", "Panelists", "Panel"),
            multipleSelection: true,
            hideSelectedItems: true,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition

        });

        $(".v-samples", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSamples", "Panelists", "Panel"),
            multipleSelection: true,
            hideSelectedItems: true,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition

        });

        $(".v-panelistExclusions", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPanelistExclusionParameter", "Panelists", "Panel"),
            multipleSelection: true,
            hideSelectedItems: true,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition
        });

        panelistFilter.initializeSurveyDispositionEmailTemplate();
        
        $(".panelistAttributesTable .conditionRow", panelistFilter.context).each(function () {
            var attributeAutoComplete = $(this).find(".conditionAttribute");
            var valueAutoComplete = $(this).find(".conditionValue");

            var attributeDefinition = attributeAutoComplete.attr("data-value");
            var attributeType = attributeAutoComplete.attr("data-type");

            $(".v-conditionAttribute", panelistFilter.context).a4autocomplete({
                ajaxAction: a4.getAction("GetPanelistAttributes", "Panelists", "Panel"),
                select: panelistFilter.selectAutoCompleteAttribute,
                tooltipProperty: "Label",
                tooltipData: "Label",
                tooltipCustomStyle: panelistFilter.tooltipStyle,
                tooltipCustomPosition: panelistFilter.tooltipPosition

            });

            panelistFilter.setAttributeValueInput(valueAutoComplete, attributeType, attributeDefinition);
        });

        $(".surveyDataTable .conditionRow", panelistFilter.context).each(function () {
            var surveyAutoComplete = $(this).find(".conditionSurvey");
            var variableAutoComplete = $(this).find(".conditionVariable");
            var valueAutoComplete = $(this).find(".conditionValue");

            var surveyId = surveyAutoComplete.attr("data-value");
            var variableId = variableAutoComplete.attr("data-value");

            surveyAutoComplete.a4autocomplete({
                ajaxAction: a4.getAction("GetSurveys", "Panelists", "Panel"),
                select: panelistFilter.selectAutoCompleteSurvey,
                tooltipProperty: "Label",
                tooltipData: "Label",
                tooltipCustomStyle: panelistFilter.tooltipStyle,
                tooltipCustomPosition: panelistFilter.tooltipPosition

            });

            variableAutoComplete.a4autocomplete({
                ajaxAction: a4.getAction("GetSurveyVariables", "Panelists", "Panel"),
                select: panelistFilter.selectAutoCompleteVariable,
                ajaxParams: { surveyId: surveyId },
                tooltipProperty: "Label",
                tooltipData: "Label",
                tooltipCustomStyle: panelistFilter.tooltipStyle,
                tooltipCustomPosition: panelistFilter.tooltipPosition

            });

            valueAutoComplete.a4autocomplete({
                ajaxAction: a4.getSurveyAction("GetVariableChoices", "Shared", { surveyId: surveyId }),
                ajaxParams: { variableName: variableId },
                validateSelection: false,
                tooltipProperty: "Label",
                tooltipData: "Label",
                tooltipCustomStyle: panelistFilter.tooltipStyle,
                tooltipCustomPosition: panelistFilter.tooltipPosition

            });
            
            panelistFilter.displayValueOptions($(this), $(this).find('.conditionOperator').val());
        });              
      
        $(".v-surveyAssignmentsHolder .survey-assignment-row", panelistFilter.context).each(function () {
            var surveyAutoComplete = $(this).find(".multiSurveysAutoComplete ");
                        
            surveyAutoComplete.a4autocomplete({
                ajaxAction: a4.getAction("GetSurveys", "Panelists", "Panel"),
                multipleSelection: true,
                hideSelectedItems: true,
                tooltipProperty: "Label",
                tooltipData: "Label",
                tooltipCustomStyle: panelistFilter.tooltipStyle,
                tooltipCustomPosition: panelistFilter.tooltipPosition

            });                              
        });
    },
    initializeDateFormat: function () {
        $("input.dateTime", panelistFilter.context).datepicker({ dateFormat: "yy-mm-dd" });
    },
    initializeSurveyDispositionEmailTemplate: function () {
        $(".v-dispositionCodes", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetDispositionCodes", "Shared", "Home"),
            multipleSelection: true,
            hideSelectedItems: true,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition

        });

        $(".surveysAutoComplete", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSurveys", "Panelists", "Panel"),
            select: panelistFilter.selectAutoCompleteSurvey,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition
        });

        $(".activityHistorySurveysAutoComplete", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSurveys", "Panelists", "Panel", { addDefaultValues: true }),
            select: panelistFilter.selectAutoCompleteSurvey,
            multipleSelection: true,
            hideSelectedItems: true,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition,
            multiSelectCustomValidationValues: { "singleselectoption": ['-1', '-2']}
        });

        $(".emailTemplatesAutoComplete", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetEmailTemplates", "Panelists", "Panel"),
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition

        });
    },
    initializeFieldCustomProperties: function () {
        $(".activity-history-section input.numeric", panelistFilter.context).each(function () {
            var inputLoadedValue = $(this).val().replace(onlyNumberRegex, '');
            $(this).val(inputLoadedValue);
        });
    },
    bindSectionDisplayEvents: function () {
        panelistFilter.context.on("change", ".filterSection .option input[type=checkbox]", function () {
            var section = $(this).closest(".filterSection");
            $(".configuration", section).toggle($(this).prop("checked"));
            $(".activity-filter-option", section).toggleClass("activity-option-selected");
        });
        panelistFilter.context.on("click", ".respondent-section-header", function () {
            var currentSection = $(this).closest('.filter-section');
            currentSection.find(".panelistfilter-subsection-title .fa").toggleClass("fa-caret-up");
            currentSection.find(".respondent-section-content").toggleClass('hideItem')
        });
        panelistFilter.context.on("click", ".toggle-respondent-filter", function () {
            panelistFilter.minimizePanelistFilter();
            setPanelistFilterExpandStatus(false);
        });
        //This way as html is appended dynamically
       $(document).on('click', '.toggle-respondent-filter-show', function () {
           panelistFilter.maximizePanelistFilter();
           setPanelistFilterExpandStatus(true);
       });

        function setPanelistFilterExpandStatus(filterIsExpanded) {
            a4.callServerMethod(a4.getAction("ModifyPanelistFilterExpandStatus", "Panelists", "Panel"), { panelId: panelistFilter.panelId, filterIsExpanded: filterIsExpanded });
        }
    },
    bindSectionsFieldEvents: function () {
        $(".activity-history-section input", panelistFilter.context).on('keypress', function (event) {
            return event.charCode >= 48 && event.charCode <= 57
        })
    },
    selectAutoCompleteAttribute: function (event, data) {
        var item = data.item;
        var autocompleteObj = $(event.target);

        if (item) {
            var itemType = item.Type.toLowerCase();

            autocompleteObj.attr("data-type", itemType);

            var row = autocompleteObj.closest(".conditionRow");
            var valueInput = $(".conditionValue", row);
            var operatorVal = $(".conditionOperator", row).val();

            panelistFilter.removeAttributeValueInput(valueInput);
            panelistFilter.setAttributeOperatorValueInput(valueInput, itemType, item.Value, operatorVal);
            valueInput.val("");
        }
    },
    setAttributeOperatorValueInput: function (input, itemType, attributeDefinition, operatorVal) {
        if (operatorVal == "In" || operatorVal == "NotIn" ||
            operatorVal == "Like" || operatorVal == "NotLike") {
            panelistFilter.setAttributeValueInput(input, "text", attributeDefinition);
        }
        else {
            panelistFilter.setAttributeValueInput(input, itemType, attributeDefinition);
        }
    },
    removeAttributeValueInput: function (input) {
        if (input.hasClass("numeric")) {
            input.autoNumeric("destroy");
            input.removeClass("numeric");
        }
        else if (input.hasClass("hasDatepicker")) {
            input.datepicker("destroy");
        }
        else if (input.hasClass("autocomplete")) {
            input.a4autocomplete("destroy");
        }
    },
    setAttributeValueInput: function (input, itemType, attributeDefinition) {
        $(input).parent().find('span').addClass('hideItem');
        $(input).parent().find('span[id="value"]').removeClass('hideItem');
        $(input).closest('.conditionRow').removeClass('isEmptyRowAdded');
        $(input).removeAttr('style');

        switch (itemType) {
            case "numeric":
                if (!input.hasClass("numeric")) {
                    $(input).attr('style', 'width: 96% !important');
                    $(input).closest('.conditionRow').find(".date-attribute-option").addClass('hideItem');
                    panelistFilter.removeAttributeValueInput(input);
                    input.autoNumeric({ aSep: '', aDec: '.', aPad: false });
                    input.addClass("numeric");
                }
                break;
            case "date":
                if (attributeDefinition == "DateOfBirth")
                {
                    if (!input.hasClass("hasDatepicker")) {
                        $(input).attr('style', 'width: 96% !important');
                        $(input).closest('.conditionRow').find(".date-attribute-option").addClass('hideItem');
                        panelistFilter.removeAttributeValueInput(input);
                        input.autoNumeric("destroy");
                        input.removeClass("numeric");
                        input.datepicker({ dateFormat: "yy-mm-dd" });
                    }
                }
                else
                {
                    $(input).parent().find('span').addClass('hideItem');
                    $(input).closest('.conditionRow').addClass('isEmptyRowAdded');
                    $(input).attr('style', 'width: 93% !important');
                    $(input).closest('.conditionRow').find(".date-attribute-option").removeClass('hideItem');
                    $(input).parent().find('span[id="date"]').removeClass('hideItem');
                    $(input).closest('.conditionRow').find(".dateAttributeOptions").change(function () {
                        $(input).parent().find('span').addClass('hideItem');
                        input.datepicker({ dateFormat: "yy-mm-dd" });

                        if ($(this).val() == "days" && attributeDefinition) {
                            $(input).parent().find('span[id="numberOfDays"]').removeClass('hideItem');
                            input.datepicker("destroy");
                            input.autoNumeric({ aSep: '', aDec: '.', aPad: false });
                            input.addClass("numeric");                            
                        }
                        else {
                            $(input).parent().find('span[id="date"]').removeClass('hideItem');
                            input.autoNumeric("destroy");
                            input.removeClass("numeric");
                            input.datepicker({ dateFormat: "yy-mm-dd" });                            
                        }
                    });
                    $(input).closest('.conditionRow').find(".dateAttributeOptions").change();
                }
                break;
            case "boolean":
                if (!input.hasClass("autocomplete")) {
                    $(input).closest('.conditionRow').find(".date-attribute-option").addClass('hideItem');

                    panelistFilter.removeAttributeValueInput(input);
                    input.a4autocomplete({
                        ajaxAction: a4.getAction("GetPanelistAttributeItems", "Panelists", "Panel"),
                        ajaxParams: { attributeDefinition: "boolean" },
                        tooltipProperty: "Label",
                        tooltipData: "Label",
                        tooltipCustomStyle: panelistFilter.tooltipStyle,
                        tooltipCustomPosition: panelistFilter.tooltipPosition

                    });
                }
                break;
            case "picklist":
                if (!input.hasClass("autocomplete")) {
                    $(input).closest('.conditionRow').find(".date-attribute-option").addClass('hideItem');

                    panelistFilter.removeAttributeValueInput(input);
                    input.a4autocomplete({
                        ajaxAction: a4.getAction("GetPanelistAttributeItems", "Panelists", "Panel"),
                        ajaxParams: { attributeDefinition: attributeDefinition },
                        tooltipProperty: "Label",
                        tooltipData: "Label",
                        tooltipCustomStyle: panelistFilter.tooltipStyle,
                        tooltipCustomPosition: panelistFilter.tooltipPosition

                    });
                }
                break;
            default:
                $(input).closest('.conditionRow').find(".date-attribute-option").addClass('hideItem');
                panelistFilter.removeAttributeValueInput(input);
        }

        var operatorVal = $(input).closest('.conditionRow').find('.conditionOperator').val();
        var isPanelistAttrTable = $(input).closest('.conditionRow').closest('table').hasClass('panelistAttributesTable')

        if ((operatorVal == "Empty" || operatorVal == "NotEmpty") && isPanelistAttrTable) {
            $(input).closest('.conditionRow').find(".date-attribute-option").addClass('hideItem');
            panelistFilter.displayValueOptions($(input).closest('.conditionRow'), operatorVal);
        }
    },
    selectAutoCompleteSurvey: function (event, data) {
        var item = data.item;
        var autocompleteObj = $(event.target);

        if (item) {
            var row = autocompleteObj.closest(".conditionRow");
            var variableInput = $(".conditionVariable", row);
            var valueInput = $(".conditionValue", row);

            var content = variableInput.closest("td.content");
            content.empty();
            content.append("<span> " + localizableTexts.Variable + "</span> <input type=\"text\" class=\"conditionVariable optionFilterSection\" data-section=\"VariableName\" />");
            variableInput = $(".conditionVariable", row);

            valueInput.val("");
            valueInput.removeAttr("data-value");
            valueInput.removeClass("autoComplete");
            valueInput.siblings(".autoCompleteButton").hide();

            variableInput.a4autocomplete({
                ajaxAction: a4.getAction("GetSurveyVariables", "Panelists", "Panel"),
                select: panelistFilter.selectAutoCompleteVariable,
                ajaxParams: { surveyId: item.Value },
                tooltipProperty: "Label",
                tooltipData: "Label",
                tooltipCustomStyle: panelistFilter.tooltipStyle,
                tooltipCustomPosition: panelistFilter.tooltipPosition

            });
        }
    },
    selectAutoCompleteVariable: function (event, data) {
        var item = data.item;
        var autocompleteObj = $(event.target);

        if (item) {
            var hasChoiceList = item.HasChoiceList;

            var row = autocompleteObj.closest(".conditionRow");
            var valueInput = $(".conditionValue", row);
            var surveyId = $(".conditionSurvey", row).attr("data-value");

            var content = valueInput.closest("td.content");
            content.empty();
            if (!row.closest('table').hasClass('panelistAttributesTable')) {
                content.append("<span id=\"value\"> " + localizableTexts.Value + "</span> <input type=\"text\" class=\"conditionValue optionFilterSection\" data-section=\"Value\" />");
            }
            else {
                content.append("<span id=\"value\"> " + localizableTexts.Value + "</span><span id=\"numberOfDays\" class=\"hideItem\">" + localizableTexts.NumberOfDays + "</span>");
                content.append("<span id=\"date\" class=\"hideItem\">" + localizableTexts.Date + "</span> <input type=\"text\" class=\"conditionValue optionFilterSection\" data-section=\"Value\" />");
            }
            valueInput = $(".conditionValue", row);

            if (hasChoiceList) {
                valueInput.a4autocomplete({
                    ajaxAction: a4.getSurveyAction("GetVariableChoices", "Shared", { surveyId: surveyId }),
                    ajaxParams: { variableName: item.Value },
                    validateSelection: false,
                    tooltipProperty: "Label",
                    tooltipData: "Label",
                    tooltipCustomStyle: panelistFilter.tooltipStyle,
                    tooltipCustomPosition: panelistFilter.tooltipPosition

                });
            }

            var row = $(this).closest(".conditionRow");
            var operatorVal = row.find('.conditionOperator').val();
            panelistFilter.displayValueOptions(row, operatorVal);

        }
    },
    setDataFilterEvents: function () {
        panelistFilter.context.on("click", ".filterDataEditor .addConditionRow", function () {
            var editor = $(this).closest(".filterDataEditor");
            var row = panelistFilter.addConditionRow(editor);
            $(".conditionValue", row).removeAttr("style");
        });

        panelistFilter.context.on("change", ".filterDataEditor .conditionOperator", function () {
            var row = $(this).closest(".conditionRow");
            panelistFilter.displayValueOptions(row, $(this).val());
        });

        panelistFilter.context.on("click", ".filterDataEditor .deleteRow", function () {
            var row = $(this).closest(".conditionRow");
            var editor = row.closest(".filterDataEditor");
            var table = $(".conditionsTable tbody", editor);

            row.remove();

            //Reindex rows
            var rowId = 1;
            $(".conditionRow", table).each(function () {
                var row = $(this);
                $(".conditionIndex", row).each(function () {
                    $(this).text(rowId);
                });
                rowId++;
            });

            if ($('tr:visible', table).length < 2) {
                $(".conditionTypePanel", editor).hide();
                $(".conditionTypePanel", editor).closest('.conditionTypeSelection').hide();
                $(".conditionType", editor).trigger("change");
            }
        });

        panelistFilter.context.on("change", ".filterDataEditor .conditionType", function () {
            var editor = $(this).closest(".filterDataEditor");
            var nbCondition = $(".conditionsTable tbody .conditionRow", editor).length;
            var toggleItem = $(this).val() == "Custom" && nbCondition > 1;
            $(".customValueSequencePanel", editor).toggle(toggleItem);

            if (toggleItem) {
                $(".conditionTypePanel", editor).addClass('showCustomOption');
            }
            else {
                $(".conditionTypePanel", editor).removeClass('showCustomOption');
            }
        });
    },
    setSurveyAssignmentFilterEvents: function () {
        var filterSection = $(".v-surveyAssignmentFilter", panelistFilter.context);

        panelistFilter.context.on("click", ".h-addSurveyAssignmentRow", function () {
            var assignmentFilterSection = $(this).closest(".v-surveyAssignmentFilter");
            panelistFilter.addSurveyAssignmentRow(assignmentFilterSection);
        });

        panelistFilter.context.on("click", ".h-deleteRow", function () {
            var p = $(this).parents(".v-surveyAssignmentCondition");
            p.parents(".survey-assignment-row").remove();

            //Reindex
            var rowId = 1;
            $(".v-surveyAssignmentsHolder .survey-assignment-row .conditionIndex").each(function () {
                $(this).text(rowId);
                rowId++;
            });
        });

        panelistFilter.context.on("change", ".h-surveyCondition", function () {
            var row = $(this).parents(".v-surveyAssignmentCondition");
            var condition = $(this).val();
            panelistFilter.displaySurveyAssignmentValueOptions(row, condition);
        });        
    },
    displaySurveyAssignmentValueOptions: function (row, value) {
        $(".v-numberOfSurvey", row).toggle(value == "AtLeast" || value == "AtMost");
        $(".v-surveySelectionSection", row).toggle(value == "AnySelected" || value == "AllSelected");

        var surveyStatus = $(".h-surveyStatus", row);
        switch (value) {
            case "Any":
                panelistFilter.displaySurveyStatus(surveyStatus, "width-95", "width-100", 'width-48');
                break;
            case "AnySelected":
            case "AllSelected":
                panelistFilter.displaySurveyStatus(surveyStatus, "width-92", "width-49", 'width-48');
                break;
            case "AtLeast":
            case "AtMost":
                panelistFilter.displaySurveyStatus(surveyStatus, "width-95", "width-100", 'width-31');
                break;
        }
    },
    displaySurveyStatus: function (element, addClass, addParentClass, upperRowClass) {
        element.parent().removeClass('width-49 width-100').addClass(addParentClass);
        element.removeClass('width-95 width-92').addClass(addClass);
        if (!panelistFilter.isPopupView) {
            element.closest('.survey-assignment-condition').find('.upperRowChild').removeClass('width-31 width-48').addClass(upperRowClass);
        }
    },
    addSurveyAssignmentRow: function (editor) {
        var placeHolder = $(".v-surveyAssignmentsHolder", editor);
        var newSurveyAssignment = $(".v-surveyAssignmentTemplate", editor).children().clone();
        var rowId = placeHolder.find('.survey-assignment-row').length + 1;
        newSurveyAssignment.find(".conditionIndex").html(rowId);
        newSurveyAssignment.appendTo(placeHolder);

        $(".v-numeric", newSurveyAssignment).autoNumeric({ aSep: '', aDec: '.', aPad: false, vMin: 0 });
        $(".v-numeric", newSurveyAssignment).autoNumeric('set', "1");

        $(".multiSurveysAutoComplete", newSurveyAssignment).a4autocomplete({
            ajaxAction: a4.getAction("GetSurveys", "Panelists", "Panel"),
            multipleSelection: true,
            hideSelectedItems: true,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition

        });

        return newSurveyAssignment;
    },
    bindFilterHeaderEvents: function () {
        panelistFilter.context.on("click", ".h-applyFilter:not(.loading)", function () {
            $(this).addClass("loading");
            a4.showBusyBox();
            var currentFilter = panelistFilter.getFilter();
            panelistFilter.context.trigger("filterChanged", currentFilter);
            panelistFilter.filterLoaded = true;
            return false;
        });

        panelistFilter.context.on("click", ".h-applyPanelistExpandedFilter", function () {
            $(this).addClass("loading");
            a4.showBusyBox();
            var currentFilter = panelistFilter.getFilter();
            panelistFilter.context.trigger("applyExpandedFilter", currentFilter);
            panelistFilter.filterLoaded = true;
            return false;
        });

        panelistFilter.context.on("filterApplied", function () {
            $(".h-applyFilter", panelistFilter.context).removeClass("loading");
            if (panelistFilter.filterLoaded)
                panelistFilter.toggleFilteredActionDropdown(true);
            a4.hideBusyBox();
        });

        panelistFilter.context.on("click", ".clearFilter:not([disabled])", function () {
            panelistFilter.loadFilter(0);
            panelistFilter.toggleFilteredActionDropdown(false);
        });

        panelistFilter.context.on("click", ".saveFilter", function () {
            panelistFilter.showSaveFilterDialog(function (filterName) {
                a4.callServerMethod(a4.getAction("SaveFilter", "Panelists", "Panel"), { name: filterName, configuration: JSON.stringify(panelistFilter.getFilter()) }, function (result) {
                    if (result.success) {
                        a4.showSuccessMessage(result.message, 5000);
                    }
                    $(".filtersAutoComplete", panelistFilter.context).a4autocomplete("clearCache");
                }, function (error) {
                    a4.showErrorMessage(sharedResources.UnexpectedError, 5000);
                });
            });
        });

        panelistFilter.context.on("click", ".deleteFilter", function () {
            modalDialog.showConfirmDialog(confirmDeleteFilterResources, function () {
                var filterId = parseInt($(".filterMainSection", panelistFilter.context).attr("data-filterId"));
                a4.callServerMethod(a4.getAction("DeleteFilter", "Panelists", "Panel"), { filterId: filterId }, function (result) {
                    if (result.success) {
                        a4.showSuccessMessage(result.message, 5000);
                    }

                    if (panelistFilter.isExpandedPanelistFilter) {
                        if (a4.top().panelistFilter.expandedFilterActionOnPopupClose == 'none') {
                            a4.top().panelistFilter.expandedFilterActionOnPopupClose = 'refreshfiltersearchbox';
                        }
                    }
                    $(".filtersAutoComplete", panelistFilter.context).a4autocomplete("clearCache");

                    panelistFilter.loadFilter(0);
                }, function (error) {
                    a4.showErrorMessage(sharedResources.UnexpectedError, 5000);
                });
            }, 250, 500, true, {});
        });

        panelistFilter.context.on("click", ".panelist-filter-expanded-view", function () {
            var model = { filterDefinition: JSON.stringify(panelistFilter.getFilter(true)), applyToSubFilter: false };

            modalDialog.showHTML(a4.getAction("PanelistFilterExpandedConfiguration", "Panelists", "Panel", model), 600, 1000, {
                beforeClose: function (iFrameWindowElement) {
                    if (iFrameWindowElement && iFrameWindowElement.panelistFilter && iFrameWindowElement.panelistFilter.getFilter) {
                        if (a4.top().panelistFilter.expandedFilterActionOnPopupClose !== 'applyfilter')
                            a4.top().panelistFilter.expandedFilterActionOnPopupClose = "applyfilterdataonly";
                        a4.top().panelistFilter.expandedFilterSavedConfiguration = iFrameWindowElement.panelistFilter.getFilter(true);
                    }

                },
                afterClose: function (event) {
                    var action = a4.top().panelistFilter.expandedFilterActionOnPopupClose;
                    var expandedFilterSavedConfiguration = a4.top().panelistFilter.expandedFilterSavedConfiguration;

                    if (action) {
                        a4.top().panelistFilter.expandedFilterActionOnPopupClose = 'none';
                        a4.top().panelistFilter.expandedFilterSavedConfiguration = null;
                        switch (action) {
                            case 'refreshfiltersearchbox':
                                $(".filtersAutoComplete", panelistFilter.context).a4autocomplete("clearCache");
                                break;
                            case 'clearfilter':
                                $(".clearFilter", panelistFilter.context).trigger("click");
                                break;
                            case 'applyfilter':
                                $(".h-applyFilter", panelistFilter.context).trigger("click");
                                break;
                            case 'applyfilterdataonly':
                                panelistFilter.context.trigger("applyExpandedFilter", expandedFilterSavedConfiguration);
                                break;
                        }
                    }
                }
            }
            );
        });
    },
    addConditionRow: function (editor) {
        var table = $(".conditionsTable tbody", editor);
        var rowId = $("tr", table).length + 1;

        var newItem = $(".newCondition .conditionRow", editor).clone();
        newItem.find(".conditionIndex").html(rowId);
        newItem.appendTo(table);

        var row = $('tr:last', table);
        $('.conditionValue', row).next('.autoCompleteButton').hide();

        if ($('tr:visible', table).length > 1) {
            $(".conditionTypePanel", editor).show();
            $(".conditionTypePanel", editor).closest('.conditionTypeSelection').show();
            $(".conditionType", editor).trigger("change");
        }

        $(".v-conditionAttribute", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPanelistAttributes", "Panelists", "Panel"),
            select: panelistFilter.selectAutoCompleteAttribute,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition

        });

        $(".v-conditionSurvey", panelistFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSurveys", "Panelists", "Panel"),
            select: panelistFilter.selectAutoCompleteSurvey,
            tooltipProperty: "Label",
            tooltipData: "Label",
            tooltipCustomStyle: panelistFilter.tooltipStyle,
            tooltipCustomPosition: panelistFilter.tooltipPosition

        });

        $(row).find(".date-attribute-option").addClass('hideItem');

        return row;
    },
    displayValueOptions: function (row, operatorVal) {
        var conditionAttribute = $(".conditionAttribute", row);
        var conditionValue = $(".conditionValue", row);
        var autoCompleteValue = conditionValue.closest(".autocomplete-container");
        var valueHidden = (operatorVal == "Empty" || operatorVal == "NotEmpty");
        var isPanelistAttrTable = row.closest('table').hasClass('panelistAttributesTable')

        if (valueHidden) {
            conditionValue.hide();
            conditionValue.parents('td.content').find('span').addClass('hideItem');
            conditionValue.closest('.conditionRow').find(".date-attribute-option").addClass('hideItem');
            if (!panelistFilter.isPopupView) {
                if (isPanelistAttrTable) {
                    row.find('.panelist-attribute-index-1, .panelist-attribute-removeitem-1').removeClass('midAlignItem');
                }
                else {
                    row.find('.removeRow').css('display', '');
                    row.find('.conditionSurvey').closest('td').css('padding-bottom', '10px');
                }
            }
        }
        else {
            conditionValue.show();
            conditionValue.parents('td').find('span').addClass('hideItem');
            conditionValue.parents('td').find('span[id="value"]').removeClass('hideItem');
            if (!panelistFilter.isPopupView) {
                if (isPanelistAttrTable) {
                    row.find('.panelist-attribute-index-1, .panelist-attribute-removeitem-1').addClass('midAlignItem');
                }
                else {
                    row.find('.conditionSurvey').closest('td').css('padding-bottom', '');
                }
            }
        }

        if (!valueHidden && conditionValue.hasClass("autocomplete")) { autoCompleteValue.show(); }
        else { autoCompleteValue.hide(); }

        if (!valueHidden && conditionAttribute) {
            var attributeType = conditionAttribute.attr("data-type");
            var attributeDefinition = conditionAttribute.attr("data-value");

            panelistFilter.setAttributeOperatorValueInput(conditionValue, attributeType, attributeDefinition, operatorVal);
            conditionValue.trigger("keypress");
        }

        if (valueHidden && isPanelistAttrTable) {
            $(row).removeClass('isEmptyRowAdded');
            $(".attribute", row).removeClass('attribute-type-1').addClass('attribute-type-2');
            $(".operator", row).removeClass('operator-type-1').addClass('operator-type-2');
        }
        else {
            $(".attribute", row).removeClass('attribute-type-2').addClass('attribute-type-1');
            $(".operator", row).removeClass('operator-type-2').addClass('operator-type-1')
        }
    },
    showSaveFilterDialog: function (saveFunction) {
        var filterName = $(".filtersAutoComplete", panelistFilter.context).val();
        var modernEditor = $('<div class="modernEditor compact panelistFilterCustomSaveDialog" />');

        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(filterLocalizableTexts.SaveFilterTitle));
        modernEditor.append(editorHeader);

        var editorContent = $('<div class="content" />');

        editorContent.append($('<div class=\"section\" />').append($('<div class="title required" />').html(localizableTexts.Name)).append($('<div class="field" />').append($('<input type=\"text\" class=\"filterName\" />').val(filterName))));

        modernEditor.append(editorContent);

        var editorFooter = $('<div class="footer" />')
            .append($('<input type="submit" class="button primary v-confirmButton" value="' + localizableTexts.Save +'"/>').html(localizableTexts.Save).on("click", function (e) {
                var filterName = $(".filterName", modernEditor).val();
                $('.error', modernEditor).remove('.error');

                if (!filterName) {
                    $('.field', modernEditor).append("<div class='error'><span class='field-validation-error' data-valmsg-for='filterName'>" + panelistErrorMessages.FieldIsRequiredError+"</span></div>");
                    return false;
                }
                else {
                    saveFunction($(".filterName", modernEditor).val());

                    if (panelistFilter.isExpandedPanelistFilter) {
                        if (a4.top().panelistFilter.expandedFilterActionOnPopupClose == 'none') {
                            a4.top().panelistFilter.expandedFilterActionOnPopupClose = 'refreshfiltersearchbox';
                        }
                        $('.fancybox-close').trigger('click')
                    }
                    else {
                        modalDialog.close();
                    }
                }
                
            }))
            .append($('<span class="link-button button-cancel"/>').html(localizableTexts.Cancel).on("click", function () {
                if (panelistFilter.isExpandedPanelistFilter) {
                    $('.fancybox-close').trigger('click')
                }
                else {
                    modalDialog.close();
                }
            }))
        modernEditor.append(editorFooter);

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            autoSize: false,
            width: 400,
            height: 200,
            autoSize: false,
            afterShow: function () {
                $('.modernEditor').find(':input:visible:enabled:first').trigger("focus");
            }
        });
    },
    loadFilter: function (filterId) {
        a4.hideErrorMessage();
        a4.showBusyBox();

        if (filterId != 0) {
            panelistFilter.filterLoaded = true;
        } else {
            panelistFilter.filterLoaded = false;
        }
        
        a4.callServerMethod(a4.getAction("GetFilterPanel", "Panelists", "Panel"), { filterId: filterId, isSampleEditor: isSampleEditor, isExpandedPanelistFilter: panelistFilter.isExpandedPanelistFilter }, function (result) {
            if (result) {
                panelistFilter.context.empty().append(result)
                panelistFilter.initializeAutoCompletes();

                //Not expanded view
                if (filterId == 0 && $("#ExpandedPanelistFilter").length <= 0) {
                        var currentFilter = panelistFilter.getFilter();
                    panelistFilter.context.trigger("filterChanged", currentFilter);
                }
                if (isSampleEditor) {
                    panelistFilter.initializeUIForFilterPanel(filterId);
                }
            }
        }, function (error) {
            a4.showErrorMessage(sharedResources.UnexpectedError, 5000);
        }, {
            complete: function (jqXHR, textStatus) {
                a4.hideBusyBox();
            }
        });
    },
    initializeUIForFilterPanel: function (filterId) {
        if (filterId == 0) {
            $('#FilterNameTextBox').parent().parent().attr('style', 'width: 100% !important');
        }
        else {
            $('#FilterNameTextBox').parent().parent().attr('style', 'width: 91% !important');
        }
    },
    getFilterValue: function (input) {
        var value = a4.getInputValue(input);
        
        if (input.is(".autocomplete")) {
            if (_.isArray(value)) {
                value = _.pluck(value, "Value");
            }
            else if (_.isObject(value)) {            

                value = value ? value["Value"] : null;
            }
        }

        return value;
    },
    getFilter: function (isExpandedView = false) {
        var filterDefinition = {};
        var currentSection;
        var filterSection;

        //Basic filter
        filterDefinition["Basic"] = {};

        $(".v-basicFilter :input.autocomplete", panelistFilter.context).each(function () {
            var optionFilterSectionAttr = $(this).attr("data-section");
            var value = panelistFilter.getFilterValue($(this));
            filterDefinition["Basic"][optionFilterSectionAttr] = value;
        });

        //Activity history
        filterDefinition["Activity"] = {};

        $(".v-activityFilter .filterSection", panelistFilter.context).each(function () {
            var filterSectionAttr = $(this).attr("data-section");
            var filterSection = null;

            if ($(this).find(".option input[type=checkbox]").is(":checked")) {
                $(this).find(":input").each(function () {
                    var value = panelistFilter.getFilterValue($(this));

                    if (value) {
                        if (!filterSection) {
                            filterSection = {};
                        }

                        var optionFilterSectionAttr = $(this).attr("data-section");

                        if (optionFilterSectionAttr) {
                            if (optionFilterSectionAttr == 'MinDays' || optionFilterSectionAttr == 'MaxDays') {
                                value = value.replace(onlyNumberRegex, '');
                            }

                            filterSection[optionFilterSectionAttr] = value;
                            if (optionFilterSectionAttr == 'SurveyIds') {
                                if (value.includes('-1')) {
                                    filterSection['SurveySelectionOption'] = -1;
                                }
                                else if (value.includes('-2')) {
                                    filterSection['SurveySelectionOption'] = -2;
                                }
                            }
                        }
                    }
                });
            }

            filterDefinition["Activity"][filterSectionAttr] = filterSection;
        });

        //Data Filter
        $(".filterDataEditor", filterSection).each(function () {
            var filterDataEditor = $(this);
            var sectionName = filterDataEditor.attr("data-section");
            filterDefinition[sectionName] = {};

            var conditionRows = $(".conditionsTable .conditionRow", filterDataEditor);

            if (conditionRows.length > 0) {
                if (conditionRows.length > 1) {
                    var conditionType = $(".conditionType", filterDataEditor).val();
                    filterDefinition[sectionName]["ConditionType"] = conditionType

                    if (conditionType == "Custom") {
                        filterDefinition[sectionName]["CustomCondition"] = $(".customValueSequence", filterDataEditor).val();
                    }
                }

                filterDefinition[sectionName]["Conditions"] = conditionRows.map(function () {
                    var condition = {};
                    $(".optionFilterSection", $(this)).each(function () {
                        var key = $(this).attr("data-section");
                        var value = panelistFilter.getFilterValue($(this));
                        condition[key] = value;
                        
                        if (key == "Attribute") {
                            condition["AttributeType"] = $(this).attr("data-type");                        
                        }
                        else
                            if (key == "Value")
                            {
                                var dateOptions = $(this).closest('.conditionRow').find(".dateAttributeOptions").find(":selected").val();
                                
                                condition["DateAsElapsedDays"] = dateOptions == "days";
                            }                        
                    });
                    if (sectionName == "SurveyData" && (condition.SurveyId == "" || condition.VariableName == "") && !isExpandedView)
                        return null
                    else
                        condition.SurveyId = ((condition.SurveyId == "") || (condition.SurveyId == null)) ? 0 : condition.SurveyId;
                        return condition;
                }).get();
            };
        });

        //Survey Assignment
        filterDefinition["SurveyAssignment"] = {};
        filterDefinition["SurveyAssignment"]["Conditions"] = $(".v-surveyAssignmentsHolder .v-surveyAssignmentCondition").map(function () {
            var surveyAssignment = {};

            $(":input", $(this)).each(function () {
                var key = $(this).attr("data-section");
                var value = panelistFilter.getFilterValue($(this));

                surveyAssignment[key] = value;
            });

            return surveyAssignment;
        }).get();

        //Panel Id
        filterDefinition["PanelId"] = panelistFilter.panelId;

        return filterDefinition;
    },
    toggleFilteredActionDropdown: function (isVisible) {
        if (typeof panelists === 'undefined')
            return;
        var totalFilteredRecords = panelists.pageTable.a4datatable("getDisplayedRecords");
        if (!$("#filteredActionDropdown").length) {
            if ($("#selectedActionDropdown").length) 
                $("#selectedActionDropdown").replaceWith(filteredActionDropdown);
            else
                $("div.toolBar").parent().prepend(filteredActionDropdown);
            panelists.toggleFilteredAction();
        }

        if (isVisible && totalFilteredRecords > 0) {
            $("#filteredActionDropdown").show();
            if (panelists.pageTable.a4datatable("getTableParams").IsSearch) {
                $('.v-toolBarButtonForFilteredRecords[data-action="export"]').hide();
                $('.v-toolBarButtonForFilteredRecords[data-action="pointtransactions"]').hide();
            } else {
                $('.v-toolBarButtonForFilteredRecords[data-action="export"]').show();
                $('.v-toolBarButtonForFilteredRecords[data-action="pointtransactions"]').show();
            }
        }
        else
            $("#filteredActionDropdown").hide();
        $('#filteredActionDropdown > div > div').html(function () {
            return $(this).html().replace($(this).text(), panelistsLocalizableTexts.FilteredActionText + " (" + totalFilteredRecords + ")");
        });
    },
    panelistFilterLoader: function () {
        panelistFilter.bindFilterHeaderEvents();
        panelistFilter.bindSectionDisplayEvents();
        panelistFilter.setDataFilterEvents();
        panelistFilter.setSurveyAssignmentFilterEvents();
        panelistFilter.initializeAutoCompletes();
        panelistFilter.bindSectionsFieldEvents();
    },
    minimizePanelistFilter: function () {
            $('.panelistfilter-right-section').css('width', '98%');
            $('.panelistfilter-left-section').addClass('hideItem');
            $('.toggle-respondent-filter-show').removeClass('hideItem').addClass('display-inline');
            $(window).trigger('resize');
        },
    maximizePanelistFilter: function () {
            $('.panelistfilter-right-section').css('width', '');
            $('.panelistfilter-left-section').removeClass('hideItem');
            $('.toggle-respondent-filter-show').addClass('hideItem').removeClass('display-inline');
            $(window).trigger('resize');
    }
}

$(document).ready(function () {
    panelistFilter.context = $(".panelistFilter");
    panelistFilter.isPopupView = $(".panelistFilter").hasClass('modalPopupView');
    panelistFilter.isExpandedPanelistFilter = $("#ExpandedPanelistFilter").length > 0
    panelistFilter.panelId = parseInt($(".filterMainSection", panelistFilter.context).attr("data-panelid"));
    panelistFilter.displayInEditor = $(".filterMainSection", panelistFilter.context).attr("data-displayineditor");
    panelistFilter.expandedFilterActionOnPopupClose = 'none';
    panelistFilter.panelistFilterLoader();

    if (!filterIsMaximized) {
        panelistFilter.minimizePanelistFilter();
    }
});